#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "map.h"

int My_host_id;

extern int Hport;
extern unsigned char My_mac_addr[];

/*
 * Find this host in the map
 */
void
find_self(struct mapfile *mp)
{
  /* Figure out who I am... */
  for (My_host_id=0; My_host_id<mp->nhost; ++My_host_id) {
    if (memcmp(mp->host[My_host_id].mac_addr, My_mac_addr, 6) == 0) {
      break;
    }
  }
  if (My_host_id >= mp->nhost) {
    fprintf(stderr, "I cannot find myself in the map file!\n");
    exit(1);
  }

  printf("I am host %s (%d, port: %d)\n", mp->host[My_host_id].mapname,
			My_host_id, Hport);
}

/*
 * Calculate a route to each xbar in the map
 */
void
calc_xbar_routes(struct mapfile *mp)
{
  struct xbar *work_list;
  struct xbar *new_work_list;
  struct xbar *xbar;
  struct xbar *xbar2;
  int p;
  int rlen;

  /* work list starts as just first xbar */
  new_work_list = NULL;

  /* put the xbar(s) that my host interface port(s) are
   * connected to on the list of xbars to check */
  for (p = 0; p < mp->host[My_host_id].nport; p++) {
    work_list = mp->host[My_host_id].port[p].xbar;
    work_list->in_port = mp->host[My_host_id].port[p].xbport;

    rlen = 0;
  
    xbar = work_list;
    xbar->rlen = 0;
    xbar->visited = 1;
  
    /*
     * Each loop processes work_list and builds up a new work_list
     * which is one hop farther away.  Then, the new work list is
     * moved to work_list. Repeat loop until work_list is empty. 
     */
    while (work_list != NULL) {
  
      /* pop off and entry to work on */
      xbar = work_list;
      work_list = xbar->route_next;
  
      for (p=0; p<MAX_XBAR_PORT; ++p) {
        xbar2 = xbar->port[p].ptr.x; /* may be invalid */
  
        /* skip non-xbar or visited connections */
        if (xbar->port[p].conn_type != CONN_XBAR || xbar2->visited) {
          continue;
        }
  
        /* fill in stuff in this xbar */
        xbar2->visited = 1;
        memcpy(xbar2->route, xbar->route, rlen);
        xbar2->route[rlen] = DELTA_TO_ROUTE(p - xbar->in_port);
        xbar2->rlen = rlen+1;
        xbar2->in_port = xbar->port[p].conn_port;
  
        /* put this on new_work_list */
        xbar2->route_next = new_work_list;
        new_work_list = xbar2;
      }
  
      /* If done with this list, increase rlen and jump to the next one */
      if (work_list == NULL) {
        ++rlen;
        work_list = new_work_list;
        new_work_list = NULL;
      }
    }
  }
}
